
#include "amg_msl_common.h"

#ifndef __RAY_TYPE
#define __RAY_TYPE
//
// Ray
//
struct Ray {
    float3 msl_origin;
    float3 msl_direction;
};

bool Ray_equal(Ray a,Ray b) {
    return all(a.msl_origin == b.msl_origin)
        && all(a.msl_direction == b.msl_direction);
}

Ray __Ray_ctor(float3 o, float3 d)
{
    Ray r;
    r.msl_origin = o;
    r.msl_direction = d;
    return r;
}

#endif // __RAY_TYPE

#ifndef __TEXTURECUBE
#define __TEXTURECUBE

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float3 coord)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord),
                   __differential_scale * ddy(coord));
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float3 coord,float3 coord_dx, float3 coord_dy)
{
    return tex.SampleGrad(smp, coord, coord_dx, coord_dy);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 blur)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 blur, int filter)
{
    if(filter == 6)
        return tex.SampleLevel(smp, _grid_snap(props, coord), 0.0);
    else
        return tex.SampleGrad(smp, coord,
                       __differential_scale * ddx(coord) * blur,
                       __differential_scale * ddy(coord) * blur);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 coord_dx, float3 coord_dy, float3 blur)
{
    return tex.SampleGrad(smp, coord,
                   coord_dy * blur,
                   coord_dy * blur);
}

float4 __texCUBE(TextureCube <float4> tex, SamplerState smp, float4 props, float3 coord, float3 coord_dx, float3 coord_dy, float3 blur, int filter)
{
    if(filter == 6)
        return tex.SampleLevel(smp, _grid_snap(props, coord), 0.0);
    else
        return tex.SampleGrad(smp, coord,
                       coord_dy * blur,
                       coord_dy * blur);
}

#endif // __TEXTURECUBE


TextureCube <float4> __msl_Reflection_Environment_map_cubic_1_env_tex : environment_map_cubic <
    string description = "The cube texture from which the environment colors will be sampled";
    string NodeName = "Reflection_Environment_map_cubic_1";
    string UIMetaSLName = "env_tex";
    string parameter_source = "Reflection_Environment_map_cubic_1";
	string UIName = "msl_Reflection_Environment_map_cubic_1_env_tex";
	string ResourceName = "default_reflection_cubic.dds";
	string ResourceType = "Cube";
>;

SamplerState __msl_Reflection_Environment_map_cubic_1_env_tex_sampler {
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Wrap;
	AddressV = Wrap;
	AddressW = Wrap;
};

float4 msl_Reflection_Environment_map_cubic_1_env_tex_props;

float msl_Reflection_Environment_map_cubic_1_intensity : environment_map_cubic_intensity
<
    string UIName = "Intensity";
    float UIMin = 0.0f;
    float UIMax = 10.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string description = "How brightly the environment map will be reflected in the scene.";
    string NodeName = "Reflection_Environment_map_cubic_1";
    string UIMetaSLName = "intensity";
    string parameter_source = "Reflection_Environment_map_cubic_1";
> = 1.0f;

int Environment_map_cubic_main_4039_628(
    inout State state,
    TextureCube <float4> __msl_env_tex, SamplerState __msl_env_tex_sampler, float4 msl_env_tex_props,
    float msl_intensity,
    out float4 msl_result,
    inout float3 msl_state_direction)
{
    {
        float3 msl_v = msl_state_direction;
        msl_result = __texCUBE(__msl_env_tex,__msl_env_tex_sampler,msl_v.xzy);
        msl_result *= __float4_ctor(msl_intensity);
    }
    return 0;
}

int Reflection_Environment_map_cubic_1_environmentmain_4039_634(
    inout State state,
    in float3 msl_state_direction,
    out float4 msl___result)
{
    float4 msl_Reflection_Environment_map_cubic_1_result;
    Environment_map_cubic_main_4039_628(
        state,
        __msl_Reflection_Environment_map_cubic_1_env_tex,
        __msl_Reflection_Environment_map_cubic_1_env_tex_sampler,
        msl_Reflection_Environment_map_cubic_1_env_tex_props,
        msl_Reflection_Environment_map_cubic_1_intensity,
        msl_Reflection_Environment_map_cubic_1_result,
        msl_state_direction);
    msl___result = msl_Reflection_Environment_map_cubic_1_result;
    return 0;
}

float4 __trace_environment(
    inout State state,
    Ray msl_ray)
{
    float4 msl_result;
    Reflection_Environment_map_cubic_1_environmentmain_4039_634(state,msl_ray.msl_direction,msl_result);
    return msl_result;
}

#define MAX_TRACE_ENVIRONMENT
